/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uihandler.AfterRestartExceptions;
import org.netbeans.modules.uihandler.Installer;
import org.netbeans.modules.uihandler.SlownessData;
import org.netbeans.modules.uihandler.SlownessReporter;
import org.netbeans.modules.uihandler.TimeToFailure;
import org.netbeans.modules.uihandler.api.Controller;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class UIHandler
extends Handler
implements ActionListener,
Runnable,
Callable<JButton> {
    private final boolean exceptionOnly;
    private volatile boolean exiting;
    public static final PropertyChangeSupport SUPPORT = new PropertyChangeSupport(Controller.getDefault());
    static final int MAX_LOGS = 1000;
    static final long MAX_LOGS_SIZE = 0x1400000L;
    private static Task lastRecord = Task.EMPTY;
    private static RequestProcessor FLUSH = new RequestProcessor("Flush UI Logs");
    private static boolean flushOnRecord;
    private static final AtomicInteger recordsToWriteOut;
    private static final int MAX_RECORDS_TO_WRITE_OUT = 1111;
    private final SlownessReporter reporter;
    private final AtomicBoolean someRecordsScheduled = new AtomicBoolean(false);
    private static boolean exceptionHandler;
    private JButton button;

    public static void registerExceptionHandler(boolean bl) {
        exceptionHandler = bl;
    }

    public UIHandler(boolean bl) {
        this.setLevel(Level.FINEST);
        this.exceptionOnly = bl;
        if (bl) {
            this.reporter = null;
            AfterRestartExceptions.report();
        } else {
            this.reporter = new SlownessReporter();
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (logRecord.getLevel().equals(Level.CONFIG) && logRecord.getMessage().startsWith("NotifyExcPanel: ")) {
            Installer.setSelectedExcParams(logRecord.getParameters());
            return;
        }
        if ("KILL_PENDING_TASKS".equals(logRecord.getMessage())) {
            this.exiting = true;
        }
        if (!this.exiting) {
            if ("SCAN_CANCELLED".equals(logRecord.getMessage())) {
                if (this.shouldReportScanCancel()) {
                    class WriteOut
                    implements Runnable {
                        public LogRecord r;

                        WriteOut() {
                        }

                        @Override
                        public void run() {
                            Installer.writeOut(this.r);
                            SUPPORT.firePropertyChange(null, null, null);
                            byte[] byArray = (byte[])this.r.getParameters()[2];
                            SlownessData slownessData = null;
                            if (byArray != null) {
                                slownessData = new SlownessData((Long)this.r.getParameters()[1], byArray, "background_scan", (String)this.r.getParameters()[3]);
                            }
                            this.r = null;
                            TimeToFailure.logAction();
                            Installer.displaySummary("ERROR_URL", true, false, true, slownessData);
                        }
                    }
                    WriteOut writeOut = new WriteOut();
                    writeOut.r = logRecord;
                    lastRecord = FLUSH.post((Runnable)writeOut);
                }
                return;
            }
            if ("SCAN_CANCELLED_EARLY".equals(logRecord.getMessage())) {
                NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(UIHandler.class, (String)"MSG_SCAN_CANCELLED_EARLY"), NbBundle.getMessage(UIHandler.class, (String)"TITLE_SCAN_CANCELLED_EARLY"), -1, 1, new Object[]{DialogDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                DialogDisplayer.getDefault().notify(notifyDescriptor);
                return;
            }
        }
        if (this.exceptionOnly) {
            if (logRecord.getThrown() == null) {
                return;
            }
            if (!exceptionHandler) {
                return;
            }
            if (AfterRestartExceptions.willSchedule(logRecord)) {
                this.someRecordsScheduled.set(true);
                boolean bl = AfterRestartExceptions.schedule(logRecord);
                if (!bl) {
                    this.someRecordsScheduled.set(false);
                }
            } else {
                this.someRecordsScheduled.set(false);
            }
        } else if (logRecord.getLevel().equals(Level.CONFIG) && logRecord.getMessage().equals("Slowness detected")) {
            String string;
            Object[] objectArray = logRecord.getParameters();
            byte[] byArray = (byte[])objectArray[0];
            long l = (Long)objectArray[1];
            String string2 = string = objectArray.length > 2 ? objectArray[2].toString() : null;
            assert (byArray != null) : "nps param should be not null";
            assert (byArray.length > 0) : "nps param should not be empty";
            this.reporter.notifySlowness(byArray, l, logRecord.getMillis(), string);
            return;
        }
        if (Installer.isImmediateWriteOut(logRecord)) {
            return;
        }
        class WriteOut
        implements Runnable {
            public LogRecord r;

            WriteOut() {
            }

            @Override
            public void run() {
                recordsToWriteOut.decrementAndGet();
                Installer.writeOut(this.r);
                SUPPORT.firePropertyChange(null, null, null);
                this.r = null;
                TimeToFailure.logAction();
            }
        }
        WriteOut writeOut = new WriteOut();
        writeOut.r = logRecord;
        recordsToWriteOut.incrementAndGet();
        lastRecord = FLUSH.post((Runnable)writeOut);
        if (flushOnRecord || recordsToWriteOut.get() > 1111) {
            UIHandler.waitFlushed(true);
        }
    }

    @Override
    public void flush() {
        UIHandler.waitFlushed();
    }

    static void flushImmediatelly() {
        flushOnRecord = true;
    }

    static void waitFlushed() {
        UIHandler.waitFlushed(false);
    }

    private static void waitFlushed(boolean bl) {
        if (!bl) assert (!SwingUtilities.isEventDispatchThread()) : "Must not wait in AWT here";
        try {
            lastRecord.waitFinished(0L);
        }
        catch (InterruptedException interruptedException) {
            Installer.LOG.log(Level.FINE, null, interruptedException);
        }
    }

    boolean isExceptionOnly() {
        return this.exceptionOnly;
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void run() {
        Installer.displaySummary("ERROR_URL", true, false, true);
        Installer.setSelectedExcParams(null);
    }

    @Override
    public JButton call() throws Exception {
        if (this.someRecordsScheduled.getAndSet(false)) {
            return null;
        }
        if (this.button == null) {
            this.button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.button, (String)NbBundle.getMessage(UIHandler.class, (String)"MSG_SubmitButton"));
            this.button.addActionListener(this);
        }
        return this.button;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        Window window = SwingUtilities.windowForComponent(jComponent);
        if (window != null) {
            window.dispose();
        }
        Installer.RP.post((Runnable)this);
    }

    private boolean shouldReportScanCancel() {
        JButton jButton = new JButton(NbBundle.getMessage(UIHandler.class, (String)"LBL_SendReport"));
        JButton jButton2 = new JButton(NbBundle.getMessage(UIHandler.class, (String)"LBL_SendReportAndProfile"));
        NotifyDescriptor notifyDescriptor = System.getProperty("org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater.indexerSampling") == null ? new NotifyDescriptor((Object)NbBundle.getMessage(UIHandler.class, (String)"MSG_SCAN_CANCELLED2"), NbBundle.getMessage(UIHandler.class, (String)"TITLE_SCAN_CANCELLED"), 1, 3, new Object[]{jButton, jButton2, DialogDescriptor.CANCEL_OPTION}, (Object)jButton) : new NotifyDescriptor((Object)NbBundle.getMessage(UIHandler.class, (String)"MSG_SCAN_CANCELLED"), NbBundle.getMessage(UIHandler.class, (String)"TITLE_SCAN_CANCELLED"), 1, 3, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton);
        Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (object == jButton2) {
            System.setProperty("org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater.indexerSampling", "true");
        }
        return object == jButton2 || object == jButton;
    }

    void publishEarlyRecords(List<LogRecord> list) {
        for (LogRecord logRecord : list) {
            this.publish(logRecord);
        }
    }

    static {
        recordsToWriteOut = new AtomicInteger(0);
    }
}

