/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BerDecoder;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.naming.CommunicationException;

final class LdapRequest {
    private static final BerDecoder EOF = new BerDecoder(new byte[0], -1, 0);
    LdapRequest next;
    final int msgId;
    private final BlockingQueue<BerDecoder> replies;
    private volatile boolean cancelled;
    private volatile boolean closed;
    private volatile boolean completed;
    private final boolean pauseAfterReceipt;

    LdapRequest(int n, boolean bl, int n2) {
        this.msgId = n;
        this.pauseAfterReceipt = bl;
        this.replies = n2 == -1 ? new LinkedBlockingQueue<BerDecoder>() : new LinkedBlockingQueue<BerDecoder>(8 * n2 / 10);
    }

    void cancel() {
        this.cancelled = true;
        this.replies.offer(EOF);
    }

    synchronized void close() {
        this.closed = true;
        this.replies.offer(EOF);
    }

    private boolean isClosed() {
        return this.closed && (this.replies.size() == 0 || this.replies.peek() == EOF);
    }

    synchronized boolean addReplyBer(BerDecoder berDecoder) {
        if (this.cancelled || this.closed) {
            return false;
        }
        try {
            berDecoder.parseSeq(null);
            berDecoder.parseInt();
            this.completed = berDecoder.peekByte() == 101;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        berDecoder.reset();
        try {
            this.replies.put(berDecoder);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.pauseAfterReceipt;
    }

    BerDecoder getReplyBer(long l) throws CommunicationException, InterruptedException {
        BerDecoder berDecoder;
        if (this.cancelled) {
            throw new CommunicationException("Request: " + this.msgId + " cancelled");
        }
        if (this.isClosed()) {
            return null;
        }
        BerDecoder berDecoder2 = berDecoder = l > 0L ? this.replies.poll(l, TimeUnit.MILLISECONDS) : this.replies.take();
        if (this.cancelled) {
            throw new CommunicationException("Request: " + this.msgId + " cancelled");
        }
        return berDecoder == EOF ? null : berDecoder;
    }

    boolean hasSearchCompleted() {
        return this.completed;
    }
}

