/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.export;

import java.io.IOException;
import java.io.Writer;
import javax.swing.table.TableModel;
import org.netbeans.modules.profiler.snaptracer.TracerProgressObject;
import org.netbeans.modules.profiler.snaptracer.impl.export.ExportBatch;

abstract class Exporter {
    protected static final int MAX_STEPS = 300;

    Exporter() {
    }

    protected abstract int getSteps(TableModel var1);

    protected void writeHeader(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
    }

    protected void writeData(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
    }

    protected void writeFooter(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
    }

    protected static void writeLine(Writer writer) throws IOException {
        writer.write("\n");
    }

    protected static void writeLine(Writer writer, String string) throws IOException {
        writer.write(string + "\n");
    }

    protected static void write(Writer writer, String string) throws IOException {
        writer.write(string);
    }

    final ExportBatch createBatch(final TableModel tableModel, final String string, final Writer writer) {
        final TracerProgressObject tracerProgressObject = new TracerProgressObject(this.getSteps(tableModel) + 2);
        ExportBatch.BatchRunnable batchRunnable = new ExportBatch.BatchRunnable(){

            @Override
            public void run() throws IOException {
                Exporter.this.doExport(tableModel, string, writer, tracerProgressObject);
            }
        };
        return new ExportBatch(tracerProgressObject, batchRunnable);
    }

    private void doExport(TableModel tableModel, String string, Writer writer, TracerProgressObject tracerProgressObject) throws IOException {
        tracerProgressObject.setText("Initializing export...");
        this.writeHeader(tableModel, string, writer, tracerProgressObject);
        if (tracerProgressObject.isFinished()) {
            return;
        }
        tracerProgressObject.addStep("Exporting data...");
        this.writeData(tableModel, string, writer, tracerProgressObject);
        if (tracerProgressObject.isFinished()) {
            return;
        }
        tracerProgressObject.setText("Finishing export...");
        this.writeFooter(tableModel, string, writer, tracerProgressObject);
        if (tracerProgressObject.isFinished()) {
            return;
        }
        tracerProgressObject.setText("Data exported");
        tracerProgressObject.finish();
    }
}

