/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.UIPlugin;
import java.awt.Color;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SWTColorToolkit {
    private static final int THUMBNAIL_SIZE = 16;
    private static final RGB BG_COLOR = new RGB(255, 255, 255);
    private static final RGB BORDER_COLOR = new RGB(0, 0, 0);

    private SWTColorToolkit() {
        throw new UnsupportedOperationException("Do not instantiate toolkit");
    }

    public static RGB asRGB(Color color) {
        return new RGB(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Image getColorThumbnail(RGB color) {
        String id;
        ImageRegistry ir = UIPlugin.getDefault().getImageRegistry();
        Image i = ir.get(id = "colored_square_" + color);
        if (i == null) {
            i = SWTColorToolkit.createColoredSquare(Display.getDefault(), 16, color);
            ir.put(id, i);
        }
        return i;
    }

    private static Image createColoredSquare(Display disp, int size, RGB color) {
        Image i = new Image((Device)disp, size, size);
        GC gc = new GC((Drawable)i);
        gc.setBackground(SWTColorToolkit.getColor(BG_COLOR));
        gc.fillRectangle(0, 0, size - 1, size - 1);
        gc.setBackground(SWTColorToolkit.getColor(color));
        gc.fillRectangle(1, 1, size - 3, size - 3);
        gc.setForeground(SWTColorToolkit.getColor(BORDER_COLOR));
        gc.drawRectangle(1, 1, size - 3, size - 3);
        gc.dispose();
        return i;
    }

    public static org.eclipse.swt.graphics.Color getColor(RGB rgb) {
        String key = rgb.toString();
        org.eclipse.swt.graphics.Color color = JFaceResources.getColorRegistry().get(key);
        if (color == null) {
            JFaceResources.getColorRegistry().put(key, rgb);
            color = JFaceResources.getColorRegistry().get(key);
        }
        return color;
    }
}

