/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.IAttributeTransformationService;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMBeanServerChangeListener;
import com.jrockit.mc.rjmx.subscription.IMRIService;
import com.jrockit.mc.rjmx.subscription.IMRITransformation;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValue;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;

public final class MBeanMRIMetaDataDB
implements IMRIService,
IMBeanServerChangeListener {
    private final IMBeanHelperService mbeanService;
    private final Map<ObjectName, Map<MRI, Map<String, Object>>> cachedMRIMetaData = new HashMap<ObjectName, Map<MRI, Map<String, Object>>>();
    private final Set<ObjectName> introspectedMBeans = new HashSet<ObjectName>();

    public MBeanMRIMetaDataDB(IMBeanHelperService mbeanService) {
        this.mbeanService = mbeanService;
    }

    @Override
    public Set<MRI> getAttributes() {
        HashSet<MRI> allMrisOnServer = new HashSet<MRI>();
        try {
            for (ObjectName mbean : this.mbeanService.getMBeanNames()) {
                allMrisOnServer.addAll(this.getMbeanData(mbean).keySet());
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to retrieve MBean names from server!", e);
        }
        return allMrisOnServer;
    }

    @Override
    public boolean isAttributeAvailable(MRI mri) {
        if (mri.getType() == MRI.Type.TRANSFORMATION) {
            return this.isTransformationAvailable(mri);
        }
        return this.getMbeanData(mri.getObjectName()).keySet().contains(mri);
    }

    private boolean isTransformationAvailable(MRI mri) {
        if (this.mbeanService instanceof IConnectionHandle) {
            IConnectionHandle handle = (IConnectionHandle)((Object)this.mbeanService);
            IAttributeTransformationService service = handle.getServiceOrNull(IAttributeTransformationService.class);
            IMRITransformation transformation = service.createTransformation(handle, mri);
            MRI[] mRIArray = transformation.getAttributes();
            int n = mRIArray.length;
            int n2 = 0;
            while (n2 < n) {
                MRI attribute = mRIArray[n2];
                if (!this.isAttributeAvailable(attribute)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mbeanUnregistered(ObjectName mbean) {
        Map<ObjectName, Map<MRI, Map<String, Object>>> map = this.cachedMRIMetaData;
        synchronized (map) {
            this.introspectedMBeans.remove(mbean);
            this.cachedMRIMetaData.remove(mbean);
        }
    }

    @Override
    public void mbeanRegistered(ObjectName mbean) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<MRI, Map<String, Object>> getMbeanData(ObjectName mbean) {
        if (this.hasIntrospectedMBean(mbean)) {
            Map<ObjectName, Map<MRI, Map<String, Object>>> map = this.cachedMRIMetaData;
            synchronized (map) {
                return this.getNonNullMap(this.cachedMRIMetaData, mbean);
            }
        }
        return this.introspectMBean(mbean);
    }

    private boolean hasIntrospectedMBean(ObjectName mbean) {
        return this.introspectedMBeans.contains(mbean);
    }

    private <K, V, C> Map<V, C> getNonNullMap(Map<K, Map<V, C>> map, K key) {
        Map<V, C> keyMap = map.get(key);
        if (keyMap == null) {
            return Collections.emptyMap();
        }
        return keyMap;
    }

    private Map<MRI, Map<String, Object>> lookupMBeanMRIData(ObjectName mbean) {
        MBeanInfo info = this.lookupMBeanInfo(mbean);
        if (info != null) {
            HashMap<MRI, Map<String, Object>> mbeanMetaData = new HashMap<MRI, Map<String, Object>>();
            MBeanFeatureInfo[] mBeanFeatureInfoArray = info.getAttributes();
            int n = mBeanFeatureInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                MBeanAttributeInfo attribute = mBeanFeatureInfoArray[n2];
                if (attribute.getName() == null) {
                    RJMXPlugin.getDefault().getLogger().warning("Omitting attribute with name==null in MBean + " + mbean.toString());
                } else {
                    if (attribute.getType() == null) {
                        RJMXPlugin.getDefault().getLogger().warning("Found MBean attribute with invalid type for " + mbean + "/" + attribute.getName());
                    }
                    mbeanMetaData.put(new MRI(MRI.Type.ATTRIBUTE, mbean, attribute.getName()), this.createMetaData(attribute));
                }
                ++n2;
            }
            mBeanFeatureInfoArray = info.getNotifications();
            n = mBeanFeatureInfoArray.length;
            n2 = 0;
            while (n2 < n) {
                MBeanFeatureInfo notification = mBeanFeatureInfoArray[n2];
                String[] stringArray = ((MBeanNotificationInfo)notification).getNotifTypes();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String type = stringArray[n4];
                    mbeanMetaData.put(new MRI(MRI.Type.NOTIFICATION, mbean, type), this.createMetaData((MBeanNotificationInfo)notification, type));
                    ++n4;
                }
                ++n2;
            }
            return mbeanMetaData;
        }
        return null;
    }

    private MBeanInfo lookupMBeanInfo(ObjectName mbean) {
        try {
            return this.mbeanService.getMBeanInfo(mbean);
        }
        catch (IOException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to retrieve MBean information from server!", e);
            return null;
        }
    }

    private Map<String, Object> createMetaData(MBeanAttributeInfo attribute) {
        String typeName = attribute.getType();
        Object originalType = attribute.getDescriptor().getFieldValue("originalType");
        if (originalType instanceof String) {
            typeName = (String)originalType;
        }
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("DisplayName", attribute.getName());
        metaData.put("Description", attribute.getDescription());
        metaData.put("AttributeType", typeName);
        metaData.put("composite", this.isCompositeType(attribute.getType()));
        metaData.put("Readable", attribute.isReadable());
        metaData.put("Writable", attribute.isWritable());
        metaData.put("Descriptor", attribute.getDescriptor());
        return metaData;
    }

    private Map<String, Object> createMetaData(MBeanNotificationInfo notification, String type) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("DisplayName", type);
        metaData.put("Description", notification.getDescription());
        metaData.put("AttributeType", notification.getName());
        metaData.put("Descriptor", notification.getDescriptor());
        return metaData;
    }

    private boolean isCompositeType(String className) {
        if (className == null) {
            return false;
        }
        try {
            return CompositeData.class.isAssignableFrom(TypeHandling.getClassWithName((String)className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MRI, Map<String, Object>> introspectMBean(ObjectName mbean) {
        HashMap<MRI, Map<String, Object>> cachedMBeanInfo;
        Map<ObjectName, Map<MRI, Map<String, Object>>> map = this.cachedMRIMetaData;
        synchronized (map) {
            Map<MRI, Map<String, Object>> mbeanMetaData = this.cachedMRIMetaData.get(mbean);
            if (mbeanMetaData == null && (mbeanMetaData = this.lookupMBeanMRIData(mbean)) == null) {
                return Collections.emptyMap();
            }
            cachedMBeanInfo = new HashMap<MRI, Map<String, Object>>(mbeanMetaData);
            boolean hasIntrospected = true;
            for (Map.Entry<MRI, Map<String, Object>> entry : mbeanMetaData.entrySet()) {
                CompositeType type = this.getCompositeType(entry.getValue());
                if (type == null && this.isComposite(entry.getValue())) {
                    CompositeData compositeData = this.getCompositeData(entry.getKey());
                    if (compositeData != null) {
                        type = compositeData.getCompositeType();
                    } else {
                        hasIntrospected = false;
                    }
                }
                if (type == null) continue;
                Object readable = entry.getValue().get("Readable");
                Object writable = entry.getValue().get("Writable");
                entry.getValue().put("composite", true);
                cachedMBeanInfo.putAll(this.introspectChildren(entry.getKey(), type, readable, writable));
            }
            this.cachedMRIMetaData.put(mbean, cachedMBeanInfo);
            if (hasIntrospected) {
                this.introspectedMBeans.add(mbean);
            }
        }
        return new HashMap<MRI, Map<String, Object>>(cachedMBeanInfo);
    }

    private boolean isComposite(Map<String, Object> metaData) {
        Object object = metaData.get("composite");
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private CompositeType getCompositeType(Map<String, Object> metaData) {
        Object type;
        Object descriptor = metaData.get("Descriptor");
        if (descriptor instanceof Descriptor && (type = ((Descriptor)descriptor).getFieldValue("openType")) instanceof CompositeType) {
            return (CompositeType)type;
        }
        return null;
    }

    private CompositeData getCompositeData(MRI mri) {
        try {
            MRIValue attributeValue = this.mbeanService.getAttribute(mri);
            if (attributeValue != null && attributeValue.getValue() instanceof CompositeData) {
                return (CompositeData)attributeValue.getValue();
            }
            return null;
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not retrieve attribute: " + mri, e);
            return null;
        }
    }

    private Map<MRI, Map<String, Object>> introspectChildren(MRI parentMRI, CompositeType parentType, Object readable, Object writable) {
        HashMap<MRI, Map<String, Object>> children = new HashMap<MRI, Map<String, Object>>();
        for (String key : parentType.keySet()) {
            String childAttribute = String.valueOf(key);
            MRI childMRI = new MRI(parentMRI, childAttribute);
            HashMap<String, Object> childMetaData = new HashMap<String, Object>();
            children.put(childMRI, childMetaData);
            childMetaData.put("DisplayName", childAttribute);
            childMetaData.put("Description", parentType.getDescription(childAttribute));
            childMetaData.put("AttributeType", parentType.getType(childAttribute).getClassName());
            childMetaData.put("Readable", readable);
            childMetaData.put("Writable", writable);
            OpenType<?> childType = parentType.getType(childAttribute);
            if (!(childType instanceof CompositeType)) continue;
            childMetaData.put("composite", true);
            children.putAll(this.introspectChildren(childMRI, (CompositeType)childType, readable, writable));
        }
        return children;
    }
}

