/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.triggers.IActivatableTriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.internal.NotificationTrigger;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class NotificationRuleBag {
    private final Set<TriggerRule> rules = new HashSet<TriggerRule>();
    private WeakReference<IConnectionHandle> handleRef = new WeakReference<Object>(null);
    private final String serverGuid;

    public NotificationRuleBag(String serverGuid) {
        this.serverGuid = serverGuid;
    }

    void activate(IConnectionHandle handle) {
        assert (handle.getServerDescriptor().getGUID().equals(this.serverGuid));
        this.handleRef = new WeakReference<IConnectionHandle>(handle);
        Iterator<TriggerRule> rulesIterator = this.rules.iterator();
        while (rulesIterator.hasNext()) {
            TriggerRule rule = rulesIterator.next();
            if (this.activateRule(rule, handle)) continue;
            rulesIterator.remove();
        }
    }

    void deactivate() {
        for (TriggerRule rule : this.rules) {
            this.deactivateRule(rule, (IConnectionHandle)this.handleRef.get());
        }
    }

    Collection<TriggerRule> getAllRegisteredRules() {
        return this.rules;
    }

    boolean removeRule(TriggerRule r) {
        if (r == null || r.getTrigger() == null || r.getTrigger().getAttributeDescriptor() == null || !this.rules.contains(r)) {
            return false;
        }
        boolean removed = this.rules.remove(r);
        this.deactivateRule(r, (IConnectionHandle)this.handleRef.get());
        return removed;
    }

    boolean addRule(TriggerRule r) {
        if (r == null || r.getTrigger() == null || r.getTrigger().getAttributeDescriptor() == null || this.rules.contains(r)) {
            return false;
        }
        this.rules.add(r);
        return this.activateRule(r, (IConnectionHandle)this.handleRef.get());
    }

    private boolean activateRule(TriggerRule r, IConnectionHandle handle) {
        if (handle != null && handle.isConnected() && (!(r.getAction() instanceof IActivatableTriggerAction) || ((IActivatableTriggerAction)((Object)r.getAction())).isActivatable(handle))) {
            handle.getServiceOrDummy(ISubscriptionService.class).addMRIValueListener(r.getTrigger().getAttributeDescriptor(), r);
            return true;
        }
        return false;
    }

    private void deactivateRule(TriggerRule r, IConnectionHandle handle) {
        if (handle != null && handle.isConnected()) {
            handle.getServiceOrDummy(ISubscriptionService.class).removeMRIValueListener(r);
        }
        if (r.getTrigger() instanceof NotificationTrigger) {
            ((NotificationTrigger)r.getTrigger()).clearState(this.serverGuid);
        }
    }
}

