/*
 * Decompiled with CFR 0.152.
 */
package edu.umons.kafka;

import edu.umons.kafka.model.RecordData;
import edu.umons.kafka.producer.RecordDataProducer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class RecordDataApp {
    public static void main(String[] args) throws IOException {
        String filePathStr = args[0];
        RecordDataApp.runProducer(filePathStr);
    }

    private static void runProducer(String filePathStr) throws IOException {
        Producer<String, RecordData> producer = RecordDataProducer.createProducer();
        Path source = null;
        try {
            source = Paths.get(filePathStr, new String[0]);
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        List<String> stringList = Files.readAllLines(source);
        stringList.remove(0);
        RecordData lastRecordData = null;
        for (int i = 0; i < stringList.size(); ++i) {
            String value = stringList.get(i);
            RecordData recordData = RecordData.build(value.split(","));
            recordData.setKafkaReadDateTime(LocalDateTime.now().toString());
            RecordDataApp.setRecordIdTime(recordData);
            RecordDataApp.sendRecordData(producer, recordData);
            if (i != stringList.size() - 1) continue;
            lastRecordData = recordData.copy();
        }
        lastRecordData.setGravAccX("end_File");
        RecordDataApp.sendRecordData(producer, lastRecordData);
    }

    private static void sendRecordData(Producer<String, RecordData> producer, RecordData recordData) {
        ProducerRecord<String, RecordData> producerRecord = new ProducerRecord<String, RecordData>("cow-datas-topic", recordData.getIdTime(), recordData);
        producer.send(producerRecord);
    }

    private static void setRecordIdTime(RecordData recordData) {
        String[] splitData = recordData.getDataTime().split("\\.");
        recordData.setIdTime(splitData[0]);
    }
}

