/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.ui.misc.AbstractWarningAction;
import com.jrockit.mc.ui.misc.DialogToolkit;
import java.io.Closeable;
import org.eclipse.osgi.util.NLS;

public class CloseRecordingAction
extends AbstractWarningAction {
    private final RecordingProvider recording;

    public CloseRecordingAction(RecordingProvider recording) {
        super(Messages.ACTION_CLOSE_RECORDING_LABEL, Messages.ACTION_CLOSE_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("FLR_close.gif"));
        this.recording = recording;
    }

    private boolean okToCloseDefaultRecording() {
        return DialogToolkit.openQuestionOnUiThread((String)Messages.CLOSE_RECORDING_TITLE, (String)NLS.bind((String)Messages.CLOSE_RECORDING_MSG, (Object)this.recording.getRecordingDescriptor().getName()));
    }

    public void doExecute() throws Exception {
        IRecordingDescriptor recordingDescriptor = this.recording.getRecordingDescriptor();
        if (recordingDescriptor.getId() != 0L || this.okToCloseDefaultRecording()) {
            IConnectionHandle connection = null;
            try {
                this.recording.setClosed();
                connection = this.recording.getServerHandle().connect(Messages.ACTION_CLOSE_RECORDING_LABEL);
                ((IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class)).close(recordingDescriptor);
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    IOToolkit.closeSilently(connection);
                }
                throw throwable;
            }
            if (connection != null) {
                IOToolkit.closeSilently((Closeable)connection);
            }
        }
    }
}

