/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.util.List;
import java.util.Random;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.netbeans.modules.uihandler.Installer;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class MetricsHandler
extends Handler {
    private static Task lastRecord = Task.EMPTY;
    private static RequestProcessor FLUSH = new RequestProcessor("Flush Metrics Logs");
    private static boolean flushOnRecord;
    static final int MAX_LOGS = 400;
    static final int MAX_DAYS;
    static final long MAX_LOGS_SIZE = 0xA00000L;

    public MetricsHandler() {
        this.setLevel(Level.FINEST);
    }

    @Override
    public void publish(LogRecord logRecord) {
        class WriteOut
        implements Runnable {
            public LogRecord r;

            WriteOut() {
            }

            @Override
            public void run() {
                Installer.writeOutMetrics(this.r);
                this.r = null;
            }
        }
        WriteOut writeOut = new WriteOut();
        writeOut.r = logRecord;
        lastRecord = FLUSH.post((Runnable)writeOut);
        if (flushOnRecord) {
            MetricsHandler.waitFlushed();
        }
    }

    @Override
    public void flush() {
        MetricsHandler.waitFlushed();
    }

    static void flushImmediatelly() {
        flushOnRecord = true;
    }

    static void setFlushOnRecord(boolean bl) {
        flushOnRecord = bl;
    }

    static void waitFlushed() {
        try {
            lastRecord.waitFinished(1000L);
        }
        catch (InterruptedException interruptedException) {
            Installer.LOG.log(Level.FINE, null, interruptedException);
        }
    }

    @Override
    public void close() throws SecurityException {
    }

    void publishEarlyRecords(List<LogRecord> list) {
        for (LogRecord logRecord : list) {
            this.publish(logRecord);
        }
    }

    static {
        MAX_DAYS = 33 + new Random(System.currentTimeMillis()).nextInt(14);
    }
}

