/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.notification.action;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.notification.action.TriggerActionJFRToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.RecordingOptionsBuilder;
import com.jrockit.mc.rjmx.triggers.IActivatableTriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;

public class TriggerActionStartContinuousJFR
extends TriggerAction
implements IActivatableTriggerAction {
    private int recordingNumber = 0;

    public void handleNotificationEvent(TriggerEvent event) throws FlightRecorderException {
        IFlightRecorderService service = (IFlightRecorderService)event.getSource().getServiceOrNull(IFlightRecorderService.class);
        if (service == null) {
            ConsolePlugin.getDefault().getLogger().severe("There is no flight recorder available on the " + event.getSource().getServerDescriptor().getDisplayName() + " JVM");
            return;
        }
        RecordingOptionsBuilder b = new RecordingOptionsBuilder();
        b.duration(0L);
        String name = this.getSetting("name").getString();
        if (++this.recordingNumber > 1) {
            name = String.valueOf(name) + " " + this.recordingNumber;
        }
        b.name(name);
        service.start(b.build(), TriggerActionJFRToolkit.getTemplate("Continuous", service));
    }

    public boolean supportsAction(IConnectionHandle handle) {
        return TriggerActionJFRToolkit.supportsJFRAction(handle);
    }

    public boolean isActivatable(IConnectionHandle handle) {
        return TriggerActionJFRToolkit.isActivatableJFRAction(handle);
    }
}

