/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy.synchronous;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.Timeline;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;

public class SynchronousXYChart
extends ChartComponent {
    private static final int[] VISIBLE_NONE = new int[]{-1, -1};
    private final Timeline timeline;
    private int[] firstVisibleIndex;
    private int[] lastVisibleIndex;
    private Map<Rectangle, int[][]> indexesCache;
    private boolean visibleIndexesDirty;
    private boolean contentsWidthChanged;
    private int oldBoundsWidth;
    private int newBoundsWidth;
    private long oldOffsetX;
    private long newOffsetX;
    private double oldScaleX;
    private double newScaleX;

    private SynchronousXYChart() {
        throw new UnsupportedOperationException("new SynchronousXYChart() not supported");
    }

    public SynchronousXYChart(SynchronousXYItemsModel synchronousXYItemsModel, PaintersModel paintersModel) {
        this.timeline = synchronousXYItemsModel.getTimeline();
        this.indexesCache = new HashMap<Rectangle, int[][]>();
        this.firstVisibleIndex = VISIBLE_NONE;
        this.lastVisibleIndex = VISIBLE_NONE;
        this.visibleIndexesDirty = true;
        this.setItemsModel(synchronousXYItemsModel);
        this.setPaintersModel(paintersModel);
        this.addConfigurationListener(new VisibleBoundsListener());
    }

    @Override
    protected Context createChartContext() {
        return new Context(this);
    }

    private int[] findFirstVisibleL(int[] nArray, int n, int n2) {
        int[] nArray2;
        int n3 = this.timeline.getTimestampsCount();
        if (n3 == 0 || nArray == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        double d = this.getDataX(n);
        int n4 = nArray[0];
        if (n4 == -1 && (double)this.timeline.getTimestamp(n4 = nArray[1]) < d) {
            return this.findFirstVisibleR(nArray, n, n2);
        }
        while (n4 > 0) {
            long l = this.timeline.getTimestamp(n4 - 1);
            if ((double)l < d) {
                return new int[]{n4, -1};
            }
            --n4;
        }
        if ((double)this.timeline.getTimestamp(n4) >= d) {
            int[] nArray3 = new int[2];
            nArray3[0] = n4;
            nArray2 = nArray3;
            nArray3[1] = -1;
        } else {
            nArray2 = VISIBLE_NONE;
        }
        return nArray2;
    }

    private int[] findLastVisibleL(int[] nArray, int n, int n2) {
        int n3 = this.timeline.getTimestampsCount();
        if (n3 == 0 || nArray == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        int n4 = nArray[0];
        if (n4 == -1) {
            n4 = nArray[1];
        }
        double d = this.getDataX(n);
        double d2 = this.getDataX(n2);
        if ((double)this.timeline.getTimestamp(n4) < d) {
            return this.findLastVisibleR(nArray, n, n2);
        }
        while (n4 >= 0) {
            long l = this.timeline.getTimestamp(n4);
            if ((double)l <= d2) {
                return new int[]{n4, -1};
            }
            --n4;
        }
        return VISIBLE_NONE;
    }

    private int[] findFirstVisibleR(int[] nArray, int n, int n2) {
        int n3 = this.timeline.getTimestampsCount();
        if (n3 == 0 || nArray == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        int n4 = nArray[0];
        if (n4 == -1) {
            n4 = nArray[1];
        }
        double d = this.getDataX(n);
        double d2 = this.getDataX(n2);
        if ((double)this.timeline.getTimestamp(n4) > d2) {
            return this.findLastVisibleL(nArray, n, n2);
        }
        int n5 = n3 - 1;
        while (n4 <= n5) {
            long l = this.timeline.getTimestamp(n4);
            if ((double)l >= d) {
                return new int[]{n4, -1};
            }
            ++n4;
        }
        return VISIBLE_NONE;
    }

    private int[] findLastVisibleR(int[] nArray, int n, int n2) {
        int[] nArray2;
        int n3 = this.timeline.getTimestampsCount();
        if (n3 == 0 || nArray == VISIBLE_NONE) {
            return VISIBLE_NONE;
        }
        double d = this.getDataX(n2);
        int n4 = nArray[0];
        if (n4 == -1 && (double)this.timeline.getTimestamp(n4 = nArray[1]) > d) {
            return this.findLastVisibleL(nArray, n, n2);
        }
        int n5 = n3 - 1;
        while (n4 < n5) {
            long l = this.timeline.getTimestamp(n4 + 1);
            if ((double)l > d) {
                return new int[]{n4, -1};
            }
            ++n4;
        }
        if ((double)this.timeline.getTimestamp(n4) <= d) {
            int[] nArray3 = new int[2];
            nArray3[0] = n4;
            nArray2 = nArray3;
            nArray3[1] = -1;
        } else {
            nArray2 = VISIBLE_NONE;
        }
        return nArray2;
    }

    private void recomputeVisibleBounds() {
        int n = this.timeline.getTimestampsCount();
        if (n == 0) {
            this.firstVisibleIndex = VISIBLE_NONE;
            this.lastVisibleIndex = VISIBLE_NONE;
        } else {
            this.firstVisibleIndex = new int[]{0, -1};
            this.lastVisibleIndex = new int[]{n - 1, -1};
            if (!this.fitsWidth()) {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
            }
        }
    }

    @Override
    protected void reshaped(Rectangle rectangle, Rectangle rectangle2) {
        if (!this.fitsWidth() && rectangle.width != rectangle2.width) {
            this.visibleIndexesDirty = true;
            this.oldBoundsWidth = rectangle.width;
            this.newBoundsWidth = rectangle2.width;
        }
        super.reshaped(rectangle, rectangle2);
    }

    private void updateVisibleIndexes() {
        if (!this.visibleIndexesDirty) {
            return;
        }
        this.indexesCache.clear();
        if (this.fitsWidth()) {
            this.recomputeVisibleBounds();
        } else if (this.contentsWidthChanged) {
            this.recomputeVisibleBounds();
        } else if (this.firstVisibleIndex == VISIBLE_NONE) {
            this.recomputeVisibleBounds();
        } else if (this.oldBoundsWidth != this.newBoundsWidth) {
            if (this.oldBoundsWidth < this.newBoundsWidth) {
                this.firstVisibleIndex = this.findFirstVisibleL(this.firstVisibleIndex, 0, this.getWidth());
                if (this.currentlyFollowingDataWidth()) {
                    this.lastVisibleIndex[0] = this.timeline.getTimestampsCount() - 1;
                    this.lastVisibleIndex[1] = -1;
                } else {
                    this.lastVisibleIndex = this.findLastVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                }
            } else {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                if (this.currentlyFollowingDataWidth()) {
                    this.lastVisibleIndex[0] = this.timeline.getTimestampsCount() - 1;
                    this.lastVisibleIndex[1] = -1;
                } else {
                    this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
                }
            }
        } else if (this.oldScaleX != this.newScaleX) {
            if (this.oldScaleX < this.newScaleX) {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
            } else {
                this.firstVisibleIndex = this.findFirstVisibleL(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleR(this.lastVisibleIndex, 0, this.getWidth());
            }
        } else if (this.oldOffsetX != this.newOffsetX) {
            if (this.newOffsetX > this.oldOffsetX) {
                this.firstVisibleIndex = this.findFirstVisibleR(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleR(this.lastVisibleIndex, 0, this.getWidth());
            } else {
                this.firstVisibleIndex = this.findFirstVisibleL(this.firstVisibleIndex, 0, this.getWidth());
                this.lastVisibleIndex = this.findLastVisibleL(this.lastVisibleIndex, 0, this.getWidth());
            }
        }
        this.contentsWidthChanged = false;
        this.oldBoundsWidth = this.newBoundsWidth;
        this.oldScaleX = this.newScaleX;
        this.oldOffsetX = this.newOffsetX;
        this.visibleIndexesDirty = false;
    }

    private int[][] getVisibleBounds(Rectangle rectangle) {
        this.updateVisibleIndexes();
        if (this.fitsWidth() || rectangle.x == 0 && rectangle.width == this.getWidth()) {
            return new int[][]{this.firstVisibleIndex, this.lastVisibleIndex};
        }
        Rectangle rectangle2 = new Rectangle(rectangle.x, 0, rectangle.width, 0);
        Object object = this.indexesCache.get(rectangle2);
        if (object == null) {
            int[] nArray = this.findFirstVisibleR(this.firstVisibleIndex, rectangle.x, rectangle.x + rectangle.width);
            int[] nArray2 = this.findLastVisibleL(this.lastVisibleIndex, rectangle.x, rectangle.x + rectangle.width);
            object = new int[][]{nArray, nArray2};
            this.indexesCache.put(rectangle2, (int[][])object);
        }
        return object;
    }

    public int getNearestTimestampIndex(int n, int n2) {
        long l;
        int n3 = this.timeline.getTimestampsCount();
        if (n3 == 0) {
            return -1;
        }
        if (n3 == 1) {
            return 0;
        }
        long l2 = (long)this.getDataX(n);
        if (this.firstVisibleIndex == VISIBLE_NONE) {
            return -1;
        }
        int n4 = this.firstVisibleIndex[0];
        if (n4 == -1) {
            n4 = this.firstVisibleIndex[1];
        }
        long l3 = this.timeline.getTimestamp(n4);
        long l4 = Math.abs(l2 - l3);
        int n5 = this.lastVisibleIndex[0];
        if (n5 == -1) {
            n5 = this.lastVisibleIndex[1];
        } else if (this.currentlyFollowingDataWidth()) {
            n5 = n3 - 1;
        }
        while (n4 + 1 <= n5 && (l = Math.abs(l2 - (l3 = this.timeline.getTimestamp(n4 + 1)))) < l4) {
            ++n4;
            l4 = l;
        }
        return n4;
    }

    protected static class Context
    extends ChartComponent.Context
    implements SynchronousXYChartContext {
        protected Context(SynchronousXYChart synchronousXYChart) {
            super(synchronousXYChart);
        }

        @Override
        protected SynchronousXYChart getChartComponent() {
            return (SynchronousXYChart)super.getChartComponent();
        }

        @Override
        public int[][] getVisibleBounds(Rectangle rectangle) {
            return this.getChartComponent().getVisibleBounds(rectangle);
        }

        @Override
        public int getNearestTimestampIndex(int n, int n2) {
            return this.getChartComponent().getNearestTimestampIndex(n, n2);
        }
    }

    private class VisibleBoundsListener
    extends ChartConfigurationListener.Adapter {
        private VisibleBoundsListener() {
        }

        @Override
        public void offsetChanged(long l, long l2, long l3, long l4) {
            if (!SynchronousXYChart.this.fitsWidth() && l != l3) {
                SynchronousXYChart.this.visibleIndexesDirty = true;
                SynchronousXYChart.this.oldOffsetX = l;
                SynchronousXYChart.this.newOffsetX = l3;
            }
        }

        @Override
        public void dataBoundsChanged(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
            if (SynchronousXYChart.this.getContentsWidth() <= (long)SynchronousXYChart.this.getWidth()) {
                SynchronousXYChart.this.visibleIndexesDirty = true;
                SynchronousXYChart.this.contentsWidthChanged = true;
            }
        }

        @Override
        public void scaleChanged(double d, double d2, double d3, double d4) {
            SynchronousXYChart.this.visibleIndexesDirty = true;
            if (!SynchronousXYChart.this.fitsWidth() && d != d3) {
                SynchronousXYChart.this.oldScaleX = d;
                SynchronousXYChart.this.newScaleX = d3;
            }
        }
    }
}

