/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.uibuilder;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.uibuilder.IUIBuilder;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormToolkitBuilder
implements IUIBuilder {
    private final FormToolkit m_toolkit;
    private static final int MAX_SPAN = 10;
    private static final int MARGIN_THICKNESS = 1;
    private Composite m_mainContainer;
    private int m_span = 10;
    private GridData m_lastGridData = null;

    public FormToolkitBuilder(FormToolkit toolkit, Composite container) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 1;
        layout.marginHeight = 1;
        layout.numColumns = 10;
        container.setLayout((Layout)layout);
        this.m_mainContainer = container;
        this.m_toolkit = toolkit;
    }

    public void setSpan(GridData gridData) {
        if (this.m_lastGridData != null) {
            this.m_lastGridData.horizontalSpan = 1;
        }
        gridData.horizontalSpan = this.m_span--;
        this.m_lastGridData = gridData;
    }

    @Override
    public Composite createComposite(Composite parent) {
        Composite composite = this.m_toolkit.createComposite(parent, 0);
        composite.setBackground(parent.getBackground());
        return composite;
    }

    @Override
    public void setCompositeLayout(Composite composite) {
        GridData gd = new GridData(4, 4, true, true);
        this.setSpan(gd);
        composite.setLayoutData((Object)gd);
    }

    @Override
    public Table createTable(Composite parent, boolean checked) {
        int style = checked ? 32 : 0;
        Table table = this.m_toolkit.createTable(parent, style);
        return table;
    }

    @Override
    public Button createButton(String text, String toolTip) {
        GridData gd = new GridData(32);
        this.setSpan(gd);
        Button button = this.m_toolkit.createButton(this.m_mainContainer, text, 0);
        button.setLayoutData((Object)gd);
        button.setToolTipText(toolTip);
        return button;
    }

    @Override
    public Label createLabel(String text, String toolTip) {
        GridData gd = new GridData(32);
        this.setSpan(gd);
        Label label = this.m_toolkit.createLabel(this.m_mainContainer, text);
        label.setToolTipText(toolTip);
        label.setLayoutData((Object)gd);
        return label;
    }

    @Override
    public Label createWrapLabel(String text, String toolTip) {
        GridData gd = new GridData(800);
        this.setSpan(gd);
        gd.grabExcessHorizontalSpace = true;
        Label label = this.m_toolkit.createLabel(this.m_mainContainer, text, 64);
        label.setText(text);
        label.setLayoutData((Object)gd);
        this.layout();
        return label;
    }

    @Override
    public Label createSeparator() {
        GridData gd = new GridData(32);
        this.setSpan(gd);
        Label label = this.m_toolkit.createLabel(this.m_mainContainer, "", 262);
        label.setLayoutData((Object)gd);
        return label;
    }

    @Override
    public void createCaption(String text) {
        GridData gd = new GridData(800);
        this.setSpan(gd);
        gd.grabExcessHorizontalSpace = true;
        Label label = this.m_toolkit.createLabel(this.m_mainContainer, text, 0);
        label.setFont(UIPlugin.getDefault().getFontColorToolkit().getStandardBoldFont());
        label.setLayoutData((Object)gd);
    }

    @Override
    public Text createMultiText(String text, String tooltip) {
        GridData gd = new GridData(1073);
        gd.grabExcessHorizontalSpace = false;
        gd.grabExcessVerticalSpace = true;
        gd.minimumWidth = 20;
        gd.minimumHeight = 20;
        Text textUI = this.createTextWithStyle(text, tooltip, 66);
        this.setSpan(gd);
        textUI.setLayoutData((Object)gd);
        return textUI;
    }

    @Override
    public Text createText(String text, String toolTip, int style) {
        GridData gd = new GridData(800);
        gd.grabExcessHorizontalSpace = true;
        Text textUI = this.createTextWithStyle(text, toolTip, style);
        this.setSpan(gd);
        textUI.setLayoutData((Object)gd);
        return textUI;
    }

    @Override
    public FormText createFormText(String text, String toolTip) {
        GridData gd = new GridData(800);
        gd.grabExcessHorizontalSpace = true;
        FormText ft = this.m_toolkit.createFormText(this.m_mainContainer, false);
        this.setSpan(gd);
        ft.setText(text, false, false);
        ft.setToolTipText(toolTip);
        ft.setLayoutData((Object)gd);
        this.layout();
        return ft;
    }

    private Text createTextWithStyle(String text, String toolTip, int style) {
        Text textUI = this.m_toolkit.createText(this.m_mainContainer, text, style);
        textUI.setToolTipText(toolTip);
        return textUI;
    }

    @Override
    public void layout() {
        this.m_span = 10;
        this.m_lastGridData = null;
        this.m_mainContainer.layout();
        this.m_toolkit.paintBordersFor(this.m_mainContainer);
    }

    @Override
    public void setContainer(Composite composite) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 10;
        layout.horizontalSpacing += 5;
        composite.setLayout((Layout)layout);
        this.m_mainContainer = composite;
    }

    @Override
    public Button createCheckBox(String text, boolean checked, String toolTip) {
        GridData gd = new GridData(32);
        this.setSpan(gd);
        Button button = this.m_toolkit.createButton(this.m_mainContainer, text, 32);
        button.setLayoutData((Object)gd);
        button.setSelection(checked);
        button.setToolTipText(toolTip);
        return button;
    }

    @Override
    public CCombo createCombo() {
        GridData gd = new GridData(800);
        this.setSpan(gd);
        CCombo combo = new CCombo(this.m_mainContainer, 0);
        this.m_toolkit.adapt((Composite)combo);
        combo.setLayoutData((Object)gd);
        return combo;
    }
}

