/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.contributions.UserInterfaceContribution;
import com.jrockit.mc.components.ui.design.LayoutItem;
import com.jrockit.mc.components.ui.tab.BaseDescriptor;
import com.jrockit.mc.components.ui.tab.TabGroupDescriptor;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ContextsWriter
implements Closeable {
    private final PrintWriter m_out;
    private final String m_pluginId;
    private int m_index;
    private static final Comparator<BaseDescriptor> COMPARATOR = new TabComparator();

    ContextsWriter(File file, String pluginId) throws FileNotFoundException {
        this.m_out = new PrintWriter(file);
        this.m_pluginId = pluginId;
    }

    void indent() {
        ++this.m_index;
    }

    void outdent() {
        --this.m_index;
    }

    public void write(UserInterfaceContribution ic) {
        this.printXML();
        this.printNLSType();
        this.printBeginContexts();
        this.printContexts(ic);
        this.printEndContexts();
    }

    @Override
    public void close() {
        this.m_out.close();
    }

    private void printEndContexts() {
        this.print("</contexts>");
    }

    private void print(String line) {
        int n = 0;
        while (n < this.m_index) {
            this.m_out.print("  ");
            ++n;
        }
        this.m_out.println(line);
    }

    private void printContexts(UserInterfaceContribution ic) {
        for (TabGroupDescriptor group : this.createdSortedGroups(ic.getUserInterface().getTabRepository().getGroups())) {
            this.printGroup(group, group.getName());
        }
    }

    private List<TabGroupDescriptor> createdSortedGroups(List<TabGroupDescriptor> groups) {
        ArrayList<TabGroupDescriptor> sorted = new ArrayList<TabGroupDescriptor>();
        sorted.addAll(groups);
        Collections.sort(sorted, COMPARATOR);
        return sorted;
    }

    private List<TabItemDescriptor> createdSortedTabs(List<TabItemDescriptor> tabs) {
        ArrayList<TabItemDescriptor> sorted = new ArrayList<TabItemDescriptor>();
        sorted.addAll(tabs);
        Collections.sort(sorted, COMPARATOR);
        return sorted;
    }

    private void printGroup(TabGroupDescriptor group, String path) {
        for (TabGroupDescriptor tg : this.createdSortedGroups(group.getGroups())) {
            this.printGroup(tg, String.valueOf(path) + " / " + tg.getName());
        }
        for (TabItemDescriptor ti : this.createdSortedTabs(group.getTabs())) {
            this.printTab(ti, String.valueOf(path) + " / " + ti.getName());
            this.indent();
            this.prinLayoutItem(ti.getLayoutItem(), String.valueOf(path) + " / " + ti.getName());
            this.outdent();
        }
    }

    private void printTab(TabItemDescriptor ti, String path) {
        this.printComment("Tab:" + path);
        this.printContext(ti.getGUID(), ti.getDescription(), ti.getName());
    }

    private void prinLayoutItem(LayoutItem parent, String path) {
        this.printComponentDescriptor(parent.getComponentDescriptor(), path);
        for (LayoutItem li : parent.getChildren()) {
            this.prinLayoutItem(li, String.valueOf(path) + " / " + this.createComponentName(li.getComponentDescriptor()));
        }
    }

    private String createComponentName(ComponentDescriptor componentDescriptor) {
        if (componentDescriptor.getName() != null || componentDescriptor.getName().trim().length() == 0) {
            return String.valueOf('[') + componentDescriptor.getTypeIdentifier() + ']';
        }
        return componentDescriptor.getName();
    }

    private void printComponentDescriptor(ComponentDescriptor cd, String path) {
        ComponentTypeDescriptor ctd = ComponentsPlugin.getDefault().getComponentTypeRegistry().getComponentTypeDescriptor(cd.getTypeIdentifier());
        if (!ctd.isContainer()) {
            this.printComment(path);
            this.printContext(cd.getGUID(), cd.getDescription(), cd.getName());
        }
    }

    private void printContext(String identifier, String description, String name) {
        this.printBeginContext(identifier);
        this.indent();
        this.printDescription(name);
        this.printTopic(this.createURI(), name);
        this.outdent();
        this.printEndContext();
        this.printBlankLine();
    }

    void printComment(String comment) {
        this.print("<!-- " + comment + " -->");
    }

    private void printBlankLine() {
        this.print("");
    }

    private String createURI() {
        return String.valueOf('/') + this.m_pluginId + "/html/";
    }

    private void printEndContext() {
        this.print("</context>");
    }

    private void printTopic(String href, String label) {
        this.print("<topic href=\"" + href + "\" label=\"\" />");
    }

    private void printDescription(String description) {
        this.print("<description>" + description + "</description>");
    }

    private void printBeginContext(String identifier) {
        this.print("<context id=\"" + identifier + "\">");
    }

    private void printBeginContexts() {
        this.print("<contexts>");
    }

    void printXML() {
        this.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    void printNLSType() {
        this.print("<?NLS TYPE=\"org.eclipse.help.contexts\"?>");
    }

    static class TabComparator
    implements Comparator<BaseDescriptor> {
        TabComparator() {
        }

        @Override
        public int compare(BaseDescriptor a, BaseDescriptor b) {
            return a.getPlacementPath().compareTo(b.getPlacementPath());
        }
    }
}

